#ifndef _MUTEX_H
#define _MUTEX_H

#	include "../ps3/PlatformMutex.h"

namespace UnityPlugin
{
	// Mutex lock, handles recursion but if you know that recursion will not happen use the much faster SimpleLock instead.
	class Mutex : public NonCopyable
	{
	public:
		class AutoLock : public NonCopyable
		{
		public:
			AutoLock( Mutex& lock ) : m_Lock(lock) { m_Lock.Lock(); }
			~AutoLock() { m_Lock.Unlock(); }
		private:
			Mutex& m_Lock;
		};

		void Lock() { m_Mutex.Lock(); }
		void Unlock() { m_Mutex.Unlock(); }

	private:
		PlatformMutex m_Mutex;
	};

	// Simple lock, very fast but do not use if recursion is a possibility.
	class SimpleLock : public NonCopyable
	{
	public:
		class AutoLock : public NonCopyable
		{
		public:
			AutoLock( SimpleLock& lock ) : m_Lock(lock) { m_Lock.Lock(); }
			~AutoLock() { m_Lock.Unlock(); }

		private:
			SimpleLock& m_Lock;
		};

		SimpleLock() : m_Count(0) {}

		void Lock()
		{
			if (AtomicIncrement(&m_Count) != 1)
			{
				m_Semaphore.WaitForSignal();
			}
		}

		void Unlock()
		{
			if (AtomicDecrement(&m_Count) != 0)
			{
				m_Semaphore.Signal();
			}
		}

	private:
		volatile int m_Count;
		PlatformSemaphore m_Semaphore;
	};

}

#endif
